<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<base href="<%=basePath%>" />

<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/mta/css/resources.css" />
<script src="<%=request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript"></script>
<script type="text/javascript">
	var baseUrl='<%= request.getContextPath()%>';
	var loginUserId='${sessionScope.user.userid}'; 
	var language="<%=session.getAttribute("language")%>"; 
	if (language.indexOf('en') > -1) {
		document.write("<script src='" + baseUrl + "/resources/js/mta_en/F030Resource.js'><\/script>");
	} else {
		// 默认中文
		document.write("<script src='" + baseUrl + "/resources/js/mta/F030Resource.js'><\/script>");
	}
</script>
</head>

<body>
	<div id="header">
	<c:import url="header.jsp"></c:import>
	</div>

		<div id="main" class="w">
			<div class="title">
				<div class="nav_crumbs l" >
					<!-- 共享资源 -->
					<span><spring:message code="label.font.resources"/></span>
					<span id="h2text" style="max-width:500px;"></span>
				</div>
				<div class="search r">
					<input type="text" name="" id="searchText" value="" placeholder="<spring:message code="label.font.searchresources"/>" class="l" />
					<a onclick="find();"><span class="r" ></span></a>
				</div>
			</div>
			<div class="menu w">
				<div class="type w" id="classifyDl">
					<!-- 分类： -->
					<span class="l"><spring:message code="label.font.classifyName"/></span>
					<ul class="detail l">
					</ul>
				</div>
				<div class="status w" id="ksStatusDl">
					<!-- 类型： -->
					<span class="l"><spring:message code="label.resource.type"/></span>
					<ul class="detail l">
						<!-- 全部 -->
						<li id="selectedKszt_0" class="l active"><spring:message code="label.font.all"/></li>
						<li id="selectedKszt_1" class="l">FLV</li>
						<li id="selectedKszt_2" class="l">MP4</li>
						<li id="selectedKszt_3" class="l">SWF</li>
						<li id="selectedKszt_4" class="l">MP3</li>
						<!-- 图片 -->
						<li id="selectedKszt_5" class="l"><spring:message code="lable.colon.image"/></li>
						<li id="selectedKszt_6" class="l">PDF</li>
						<li id="selectedKszt_7" class="l">WORD</li>
						<li id="selectedKszt_8" class="l">EXCEL</li>
						<li id="selectedKszt_9" class="l">PPT</li>
						<!-- 其它 -->
						<li id="selectedKszt_10" class="l"><spring:message code="lable.colon.others"/></li>
					</ul>
				</div>
			</div>
			<div class="content">
				<div class="course_title" id="newhot">
					<!-- 最新 -->
					<span class=" newhot active" id="newhot_1"><spring:message code="label.font.zx"/></span>
					<!-- 最热 -->
					<span class="newhot" id="newhot_2"><spring:message code="label.font.zr"/></span>
				</div>
				<div class="resource">
					<table id="resourceList" cellspacing="0" cellpadding="0" border="0">
						<thead>
							<tr>
								<!-- 类型 -->
								<th width="50"><spring:message code="label.myresource.type"/></th>
								<!-- 资源名称 -->
								<th width="450"><spring:message code="label.resource.name"/></th>
								<!-- 上传者 -->
								<th width="110"><spring:message code="label.resource.upuser"/></th>
								<!-- 文件大小 -->
								<th width="110"><spring:message code="label.resource.size"/></th>
								<!-- 上传时间 -->
								<th width="120"><spring:message code="label.resource.uptime"/></th>
								<!-- 下载次数 -->
								<th width="110"><spring:message code="label.resource.downloadtimes"/></th>
								<!-- 下载 -->
								<th width="100"><spring:message code="label.resource.download"/></th>
							</tr>
						</thead>
						<tbody>
						</tbody>
					</table>
				</div>
			</div>
			<div class="numb" id="resourcePage">
			<%@include file="page.jsp" %>
			</div>
		</div>

	<div id="footer">
	<c:import url="footer.jsp"></c:import>
	</div>
</body>
</html>